# MATIKO - Deployment Guide (With PesaPal)

## ✅ What Was Changed for PesaPal

### 1. render.yaml
```diff
- QUEUE_CONNECTION: sync
+ QUEUE_CONNECTION: database  # CRITICAL for PesaPal callbacks

+ Added PesaPal environment variables:
  - PESAPAL_LIVE=false
  - PESAPAL_CONSUMER_KEY=qkio1BGGYAXTu2JOfm7XSXNruoZsrqEW
  - PESAPAL_CONSUMER_SECRET=osGQ364R49cXKeOYSpaOnT++rHs=
```

### 2. docker/supervisord.conf
```diff
+ Added queue worker process:
  [program:queue-worker]
  - Processes PesaPal callbacks/IPNs
  - Auto-restarts on failure
  - Runs as www-data user
```

### 3. docker/entrypoint.sh
```diff
- php artisan migrate:fresh --force --seed
+ php artisan migrate --force  # Won't delete data on redeploy

+ php artisan pesapal:auth  # Registers IPN on deployment
```

---

## 🚀 Deployment Steps

### Step 1: Commit Changes

```bash
# Check status
git status

# Add all changes
git add .

# Commit with clear message
git commit -m "Add PesaPal payment integration with queue worker

- Added PesaPal API v3 integration
- Changed QUEUE_CONNECTION to database for async processing
- Added queue worker to supervisord
- Added PesaPal env vars to render.yaml
- Updated entrypoint to run pesapal:auth
- Created PesapalService, models, jobs, and controllers
"

# Check remote
git remote -v
```

### Step 2: Push to GitHub

```bash
# If you need to set remote (replace with your repo URL)
git remote set-url origin https://github.com/sammyger00/MATIKO.git

# Push to main branch
git push origin main
```

**If you get authentication error:**
```bash
# Use GitHub Personal Access Token
# Generate one at: https://github.com/settings/tokens
# Then use it as password when prompted
```

### Step 3: Render Will Auto-Deploy

Once pushed, Render will:
1. ✅ Pull latest code
2. ✅ Build Docker image
3. ✅ Run migrations
4. ✅ Register PesaPal IPN
5. ✅ Start queue worker
6. ✅ Deploy application

**Monitor deployment:**
- Go to: https://dashboard.render.com
- Click on "matiko" service
- Watch the "Logs" tab

---

## 📊 Post-Deployment Verification

### 1. Check if Queue Worker is Running

In Render logs, look for:
```
[program:queue-worker] Processing jobs...
```

### 2. Check PesaPal Authentication

Look for in logs:
```
Registering PesaPal IPN...
PesaPal token created successfully
```

### 3. Test PesaPal Payment

```bash
# Get your Render URL
# Example: https://matiko.onrender.com

# Test payment initiation
curl -X POST https://matiko.onrender.com/api/v1/pesapal/initiate \
  -H "Content-Type: application/json" \
  -d '{
    "order_id": 1,
    "phone_number": "0712345678",
    "email": "test@example.com"
  }'
```

**Expected Response:**
```json
{
  "success": true,
  "message": "Payment initiated successfully",
  "data": {
    "order_tracking_id": "abc123...",
    "redirect_url": "https://cybqa.pesapal.com/..."
  }
}
```

### 4. Check Database Tables

Connect to your PostgreSQL database and verify:

```sql
-- Check if tables exist
SELECT table_name FROM information_schema.tables
WHERE table_schema = 'public'
AND table_name IN ('pesapal_transactions', 'pesapal_tokens', 'pesapal_ipns');

-- Check PesaPal token
SELECT * FROM pesapal_tokens ORDER BY created_at DESC LIMIT 1;

-- Check IPN registration
SELECT * FROM pesapal_ipns ORDER BY created_at DESC LIMIT 1;
```

---

## 🧪 Testing Complete Payment Flow

### 1. Create Test Order

Use your frontend or API to create an order with:
```json
{
  "payment_method": "pesapal"
}
```

### 2. Initiate Payment

```bash
POST /api/v1/pesapal/initiate
```

### 3. Complete Payment

1. Visit the `redirect_url` from the response
2. Use PesaPal sandbox test credentials
3. Complete the payment

### 4. Verify Ticket Generation

Check logs for:
```
✓ Payment completed for Order XXX
✓ Tickets generated successfully for Order XXX
```

Check database:
```sql
-- Should show COMPLETED status
SELECT * FROM pesapal_transactions ORDER BY created_at DESC LIMIT 1;

-- Should have new tickets
SELECT * FROM tickets WHERE order_id = X;
```

---

## 🔧 Troubleshooting

### Issue: Queue worker not processing jobs

**Check logs for:**
```
[program:queue-worker] STARTING
```

**If not found, check supervisord status:**
```bash
# SSH into Render (if possible) or check logs
supervisorctl status
```

**Solution:** Queue worker is configured in supervisord.conf and should start automatically

---

### Issue: PesaPal auth fails

**Error in logs:**
```
PesaPal auth failed or already registered
```

**This is OK!** It means:
- Either authentication succeeded earlier
- Or there's a temporary network issue
- The system will retry on next request

**To manually re-authenticate:**
```bash
# In Render shell (if available)
php artisan pesapal:auth
```

---

### Issue: Callbacks not processing

**Check:**
1. Is queue worker running? (supervisorctl status)
2. Are jobs in the queue? (SELECT * FROM jobs)
3. Are there failed jobs? (SELECT * FROM failed_jobs)

**Debug:**
```sql
-- Check queue
SELECT * FROM jobs ORDER BY created_at DESC;

-- Check failed jobs
SELECT * FROM failed_jobs ORDER BY failed_at DESC;
```

---

### Issue: No tickets generated

**Check:**
1. Payment status: `SELECT status FROM pesapal_transactions WHERE order_tracking_id = 'XXX'`
2. Order status: `SELECT payment_status FROM orders WHERE id = X`
3. Logs for errors: Look for "Failed to generate tickets"

**Verify TicketService:**
```bash
# Test manually
php artisan tinker
$order = Order::find(1);
app(\App\Services\TicketService::class)->generateTickets($order);
```

---

## 🎯 Environment Variables Checklist

Verify these are set in Render Dashboard:

**Required:**
- [x] `QUEUE_CONNECTION=database`
- [x] `PESAPAL_LIVE=false`
- [x] `PESAPAL_CONSUMER_KEY=qkio1BGGYAXTu2JOfm7XSXNruoZsrqEW`
- [x] `PESAPAL_CONSUMER_SECRET=osGQ364R49cXKeOYSpaOnT++rHs=`

**Database (Auto-configured):**
- [x] `DB_CONNECTION=pgsql`
- [x] `DB_HOST` (from database)
- [x] `DB_PORT` (from database)
- [x] `DB_DATABASE` (from database)
- [x] `DB_USERNAME` (from database)
- [x] `DB_PASSWORD` (from database)

---

## 📝 Production Checklist

Before going live with real payments:

### 1. Get Production API Keys
- Login to PesaPal dashboard
- Get production Consumer Key & Secret
- Update Render environment variables:
  ```
  PESAPAL_LIVE=true
  PESAPAL_CONSUMER_KEY=your_production_key
  PESAPAL_CONSUMER_SECRET=your_production_secret
  ```

### 2. Update Callback URLs
- PesaPal will send callbacks to your production URL
- No code changes needed - routes use `APP_URL`
- Just ensure `APP_URL` is set correctly in Render

### 3. Test in Production
1. Create real order
2. Initiate payment
3. Pay with real M-Pesa/Card
4. Verify ticket generation
5. Verify email/SMS notifications

### 4. Monitor
- Watch Render logs during first payments
- Check failed_jobs table regularly
- Set up error alerts if needed

---

## 🎉 Success Indicators

After successful deployment, you should see:

**In Logs:**
```
✓ Server running on port 80
✓ Queue worker started
✓ PesaPal IPN registered
✓ Migrations completed
```

**In Database:**
```sql
pesapal_tokens: Has valid token
pesapal_ipns: Has registered IPN
jobs: Processing queue items
```

**In Testing:**
```
✓ Payment initiated successfully
✓ Redirect URL received
✓ Payment completed on PesaPal
✓ Callback processed
✓ IPN received
✓ Tickets generated
✓ User notified
```

---

## 📞 Support

If you encounter issues:

1. **Check Logs:** Render Dashboard → matiko → Logs tab
2. **Check Database:** Use Render's database viewer
3. **Check Failed Jobs:** `SELECT * FROM failed_jobs`
4. **Check PesaPal Status:** POST to `/api/v1/pesapal/status/{orderTrackingId}`

---

**Status:** ✅ Ready to Deploy
**Next Step:** Run the git commands above to push and deploy!
