<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:check-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check users and their roles';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $users = \App\Models\User::with('roles')->get();

        $this->info('=== CHECKING USERS AND ROLES ===');
        $this->newLine();

        foreach ($users as $user) {
            $this->info("Email: {$user->email}");
            $this->info("Name: {$user->name}");
            $this->info("Roles: " . $user->roles->pluck('name')->join(', '));
            $this->info("Has super_admin role: " . ($user->hasRole('super_admin') ? 'Yes' : 'No'));
            $this->info("Has admin role: " . ($user->hasRole('admin') ? 'Yes' : 'No'));
            $this->line('---');
        }

        return Command::SUCCESS;
    }
}
