<?php

namespace App\Console\Commands;

use App\Services\SettingsService;
use Illuminate\Console\Command;

class MigrateEnvToSettings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'settings:migrate-env';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Migrate API keys from .env to database';

    /**
     * Execute the console command.
     */
    public function handle(SettingsService $settings)
    {
        $this->info('Migrating settings from .env to database...');

        // Daraja
        $settings->set('daraja.base_url', env('DARAJA_BASE_URL'), 'payment', false);
        $settings->set('daraja.key', env('DARAJA_CONSUMER_KEY'), 'payment', true);
        $settings->set('daraja.secret', env('DARAJA_CONSUMER_SECRET'), 'payment', true);
        $settings->set('daraja.shortcode', env('DARAJA_SHORTCODE'), 'payment', false);
        $settings->set('daraja.passkey', env('DARAJA_PASSKEY'), 'payment', true);
        $settings->set('daraja.callback_url', env('DARAJA_CALLBACK_URL'), 'payment', false);

        // Mail
        $settings->set('mail.mailer', env('MAIL_MAILER'), 'mail', false);
        $settings->set('mail.host', env('MAIL_HOST'), 'mail', false);
        $settings->set('mail.port', env('MAIL_PORT'), 'mail', false);
        $settings->set('mail.username', env('MAIL_USERNAME'), 'mail', false);
        $settings->set('mail.password', env('MAIL_PASSWORD'), 'mail', true);
        $settings->set('mail.encryption', env('MAIL_ENCRYPTION'), 'mail', false);
        $settings->set('mail.from.address', env('MAIL_FROM_ADDRESS'), 'mail', false);

        // SMS
        $settings->set('africastalking.username', env('AFRICASTALKING_USERNAME'), 'sms', false);
        $settings->set('africastalking.key', env('AFRICASTALKING_API_KEY'), 'sms', true);
        $settings->set('africastalking.from', env('AFRICASTALKING_FROM'), 'sms', false);

        // Business (defaults)
        $settings->set('business.name', env('APP_NAME', 'MATIKO'), 'business', false);
        $settings->set('business.phone', env('BUSINESS_PHONE', ''), 'business', false);
        $settings->set('business.email', env('BUSINESS_EMAIL', env('MAIL_FROM_ADDRESS')), 'business', false);

        $this->info('✓ Settings migrated successfully!');

        return 0;
    }
}
