<?php

namespace App\Filament\Resources\Agents\Pages;

use App\Filament\Resources\Agents\AgentResource;
use App\Models\User;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateAgent extends CreateRecord
{
    protected static string $resource = AgentResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $userId = null;

        // Check if we're creating a new user or using an existing one
        if (isset($data['user_mode']) && $data['user_mode'] === 'existing') {
            // Mode 1: Use existing user
            $userId = $data['user_id'];
        } else {
            // Mode 2: Create new user
            $user = User::create([
                'name' => $data['name'],
                'email' => $data['email'],
                'phone' => $data['phone'],
                'password' => bcrypt($data['password'] ?? 'password123'),
                'role' => 'agent',
                'status' => 'active',
            ]);

            $userId = $user->id;
        }

        // Assign agent role to the user
        $user = User::find($userId);
        if (!$user->hasRole('agent')) {
            $user->assignRole('agent');
        }

        // Replace the form data with user_id and keep assigned_events
        return [
            'user_id' => $userId,
            'assigned_events' => $data['assigned_events'] ?? [],
        ];
    }
}
