<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\Http\JsonResponse;

class PublicPageController extends Controller
{
    /**
     * Get page by slug
     *
     * @param string $slug
     * @return JsonResponse
     */
    public function show(string $slug): JsonResponse
    {
        $page = Page::where('slug', $slug)
            ->where('status', 'published')
            ->first();

        if (!$page) {
            return response()->json([
                'success' => false,
                'message' => 'Page not found',
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => [
                'id' => $page->id,
                'title' => $page->title,
                'slug' => $page->slug,
                'content' => $page->content,
                'excerpt' => $page->excerpt,
                'template' => $page->template,
                'meta' => $page->meta,
                'created_at' => $page->created_at,
                'updated_at' => $page->updated_at,
            ],
        ]);
    }

    /**
     * Get all published pages
     *
     * @return JsonResponse
     */
    public function index(): JsonResponse
    {
        $pages = Page::where('status', 'published')
            ->select(['id', 'title', 'slug', 'excerpt', 'created_at', 'updated_at'])
            ->orderBy('title')
            ->get();

        return response()->json([
            'success' => true,
            'data' => $pages,
        ]);
    }
}
