<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\TicketCategory;
use Illuminate\Http\Request;

class EventController extends Controller
{
    public function index()
    {
        // Get all events ordered by date (newest first for past events, soonest first for future)
        $events = Event::orderBy('event_date', 'desc')
            ->get();

        return view('events.index', compact('events'));
    }

    public function show($id)
    {
        $event = Event::with('categories')->findOrFail($id);
        return view('events.show', compact('event'));
    }
}
