<?php

namespace App\Providers;

use App\Services\SettingsService;
use App\View\Composers\MenuComposer;
use App\View\Composers\SettingsComposer;
use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register SettingsService as singleton
        $this->app->singleton(SettingsService::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Force HTTPS in production
        if ($this->app->environment('production')) {
            URL::forceScheme('https');
        }

        ResetPassword::createUrlUsing(function (object $notifiable, string $token) {
            return config('app.frontend_url')."/password-reset/$token?email={$notifiable->getEmailForPasswordReset()}";
        });

        // Register view composers for layout
        View::composer('layout', MenuComposer::class);
        View::composer('layout', SettingsComposer::class);

        // Also register SettingsComposer for pages that might not use layout
        View::composer('pages.*', SettingsComposer::class);
    }
}
