<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationItem;
use Filament\Pages\Dashboard;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use App\Filament\Widgets\RevenueStatsOverview;
use App\Filament\Widgets\RevenueChart;
use App\Filament\Widgets\TicketsSoldChart;
use App\Services\SettingsService;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        $settings = app(SettingsService::class);

        // Get dynamic branding from settings
        $brandName = $settings->get('business.name', config('app.name', 'MATIKO'));
        $logoUrl = $settings->get('business.logo_url');
        $faviconUrl = $settings->get('business.favicon_url');

        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login()
            ->brandName($brandName)
            ->when(
                $logoUrl,
                fn (Panel $panel) => $panel->brandLogo($logoUrl)
            )
            ->when(
                $faviconUrl,
                fn (Panel $panel) => $panel->favicon($faviconUrl)
            )
            ->colors([
                'primary' => Color::Amber,
            ])
            ->navigationGroups([
                NavigationGroup::make('Events')
                    ->collapsible(false),
                NavigationGroup::make('Sales')
                    ->collapsible(false),
                NavigationGroup::make('Reports')
                    ->collapsible(false),
                NavigationGroup::make('Users')
                    ->collapsible(false),
                NavigationGroup::make('Content Management')
                    ->collapsible(false),
                NavigationGroup::make('Configuration')
                    ->collapsible(false),
            ])
            ->navigationItems([
                NavigationItem::make('Back to Website')
                    ->url('/', shouldOpenInNewTab: true)
                    ->icon('heroicon-o-arrow-left-circle')
                    ->sort(-1),
            ])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\Filament\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\Filament\Pages')
            ->pages([
                Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\Filament\Widgets')
            ->widgets([
                RevenueStatsOverview::class,
                RevenueChart::class,
                TicketsSoldChart::class,
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ]);
    }
}
