<?php

namespace App\Services;

use Exception;
use AfricasTalking\SDK\AfricasTalking;

class AfricasTalkingService
{
    protected $at;
    protected $sms;

    public function __construct()
    {
        $username = config('services.africastalking.username');
        $apiKey = config('services.africastalking.key');

        $this->at = new AfricasTalking($username, $apiKey);
        $this->sms = $this->at->sms();
    }

    public function sendSms($to, $message)
    {
        try {
            $result = $this->sms->send([
                'to' => $to,
                'message' => $message,
                'from' => config('services.africastalking.from'),
            ]);
            return $result;
        } catch (Exception $e) {
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }

}
