<?php

namespace App\View\Composers;

use App\Models\Menu;
use Illuminate\View\View;

class MenuComposer
{
    /**
     * Bind data to the view.
     */
    public function compose(View $view)
    {
        $topbarMenu = Menu::with(['items.children.page', 'items.page'])
            ->where('location', 'topbar')
            ->where('status', 'active')
            ->first();

        $footerMenu = Menu::with(['items.children.page', 'items.page'])
            ->where('location', 'footer')
            ->where('status', 'active')
            ->first();

        $view->with([
            'topbarMenu' => $topbarMenu,
            'footerMenu' => $footerMenu,
        ]);
    }
}
