<?php

namespace App\View\Composers;

use App\Services\SettingsService;
use Illuminate\View\View;

class SettingsComposer
{
    protected SettingsService $settings;

    public function __construct(SettingsService $settings)
    {
        $this->settings = $settings;
    }

    public function compose(View $view): void
    {
        $view->with('appSettings', [
            'name' => $this->settings->get('business.name', config('app.name', 'MATIKO')),
            'email' => $this->settings->get('business.email', 'info@matiko.com'),
            'phone' => $this->settings->get('business.phone', '+254700000000'),
            'address' => $this->settings->get('business.address', 'Nairobi, Kenya'),
            'description' => $this->settings->get('business.description', 'Your premier event ticketing platform'),
            'logo_url' => $this->settings->get('business.logo_url'),
            'favicon_url' => $this->settings->get('business.favicon_url'),
            'seo' => [
                'title' => $this->settings->get('seo.title', 'MATIKO - Event Ticketing Platform'),
                'description' => $this->settings->get('seo.description', 'Book tickets for the best events in Kenya.'),
                'keywords' => $this->settings->get('seo.keywords', 'events, tickets, kenya'),
            ],
            'social' => [
                'facebook' => $this->settings->get('social.facebook'),
                'twitter' => $this->settings->get('social.twitter'),
                'instagram' => $this->settings->get('social.instagram'),
                'linkedin' => $this->settings->get('social.linkedin'),
            ],
        ]);
    }
}
