<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->trustProxies(at: '*');

        $middleware->api(prepend: [
            \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
        ]);

        $middleware->alias([
            'verified' => \App\Http\Middleware\EnsureEmailIsVerified::class,
            'role' => \App\Http\Middleware\CheckRole::class,
        ]);

        //
    })
    ->withSchedule(function (\Illuminate\Console\Scheduling\Schedule $schedule): void {
        // Clean expired ticket holds every minute
        $schedule->call(function () {
            $ticketHoldService = app(\App\Services\TicketHoldService::class);
            $deleted = $ticketHoldService->cleanExpiredHolds();
            if ($deleted > 0) {
                \Illuminate\Support\Facades\Log::info("Cleaned {$deleted} expired ticket holds");
            }
        })->everyMinute()->name('clean-expired-holds');
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
