<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pesapal_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('order_tracking_id')->unique()->index();
            $table->string('merchant_reference')->index();
            $table->foreignId('order_id')->nullable()->constrained()->onDelete('set null');
            $table->decimal('amount', 10, 2);
            $table->string('currency', 3)->default('KES');
            $table->string('status')->default('PENDING'); // PENDING, COMPLETED, FAILED, CANCELLED
            $table->string('payment_method')->nullable(); // MPESA, CARD, BANK, etc.
            $table->text('description')->nullable();
            $table->text('redirect_url')->nullable();
            $table->string('confirmation_code')->nullable();
            $table->text('payment_status_description')->nullable();
            $table->json('callback_data')->nullable();
            $table->json('ipn_data')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pesapal_transactions');
    }
};
