<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Setting;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Rename airtel_money_enabled to pesapal_enabled
        // First check if pesapal_enabled already exists
        $pesapalExists = Setting::where('key', 'features.pesapal_enabled')->exists();
        $airtelExists = Setting::where('key', 'features.airtel_money_enabled')->exists();

        if ($airtelExists && !$pesapalExists) {
            // Only rename if airtel exists and pesapal doesn't
            Setting::where('key', 'features.airtel_money_enabled')
                ->update(['key' => 'features.pesapal_enabled']);
        } elseif ($airtelExists && $pesapalExists) {
            // Both exist, delete airtel and keep pesapal
            Setting::where('key', 'features.airtel_money_enabled')->delete();
        }
        // If only pesapal exists, do nothing (already migrated)

        // Add PesaPal settings if they don't exist
        $pesapalSettings = [
            [
                'key' => 'pesapal.live',
                'value' => 'false',
                'group' => 'payment',
                'type' => 'boolean',
                'is_encrypted' => false,
            ],
            [
                'key' => 'pesapal.consumer_key',
                'value' => 'qkio1BGGYAXTu2JOfm7XSXNruoZsrqEW',
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => true,
            ],
            [
                'key' => 'pesapal.consumer_secret',
                'value' => 'osGQ364R49cXKeOYSpaOnT++rHs=',
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => true,
            ],
            [
                'key' => 'pesapal.callback_url',
                'value' => url('/api/v1/pesapal/callback'),
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'pesapal.ipn_url',
                'value' => url('/api/v1/pesapal/ipn'),
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => false,
            ],
        ];

        foreach ($pesapalSettings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Rename back to airtel_money_enabled
        Setting::where('key', 'features.pesapal_enabled')
            ->update(['key' => 'features.airtel_money_enabled']);

        // Optionally remove PesaPal settings (uncomment if you want to remove them on rollback)
        // Setting::whereIn('key', [
        //     'pesapal.live',
        //     'pesapal.consumer_key',
        //     'pesapal.consumer_secret',
        //     'pesapal.callback_url',
        //     'pesapal.ipn_url',
        // ])->delete();
    }
};
