<?php

namespace Database\Seeders;

use App\Models\Menu;
use App\Models\MenuItem;
use App\Models\Page;
use Illuminate\Database\Seeder;

class DefaultMenusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Creating default menus...');

        // Get pages for linking
        $howItWorksPage = Page::where('slug', 'how-it-works')->first();
        $helpCenterPage = Page::where('slug', 'help-center')->first();
        $contactUsPage = Page::where('slug', 'contact-us')->first();
        $aboutUsPage = Page::where('slug', 'about-us')->first();
        $privacyPolicyPage = Page::where('slug', 'privacy-policy')->first();
        $termsOfServicePage = Page::where('slug', 'terms-of-service')->first();

        // Topbar Menu
        $topbar = Menu::create([
            'name' => 'Main Navigation',
            'location' => 'topbar',
            'status' => 'active',
        ]);

        MenuItem::create([
            'menu_id' => $topbar->id,
            'label' => 'Browse Events',
            'url' => '/',
            'url_type' => 'custom',
            'order' => 1,
        ]);

        if ($aboutUsPage) {
            MenuItem::create([
                'menu_id' => $topbar->id,
                'label' => 'About Us',
                'page_id' => $aboutUsPage->id,
                'url_type' => 'page',
                'order' => 2,
            ]);
        }

        if ($howItWorksPage) {
            MenuItem::create([
                'menu_id' => $topbar->id,
                'label' => 'How It Works',
                'page_id' => $howItWorksPage->id,
                'url_type' => 'page',
                'order' => 3,
            ]);
        }

        MenuItem::create([
            'menu_id' => $topbar->id,
            'label' => 'My Tickets',
            'url' => 'my.tickets',
            'url_type' => 'route',
            'order' => 4,
        ]);

        $this->command->info('✓ Topbar menu created');

        // Footer Menu
        $footer = Menu::create([
            'name' => 'Footer Links',
            'location' => 'footer',
            'status' => 'active',
        ]);

        $quickLinks = MenuItem::create([
            'menu_id' => $footer->id,
            'label' => 'Quick Links',
            'url_type' => 'custom',
            'order' => 1,
        ]);

        MenuItem::create([
            'menu_id' => $footer->id,
            'parent_id' => $quickLinks->id,
            'label' => 'Browse Events',
            'url' => '/',
            'url_type' => 'custom',
            'order' => 1,
        ]);

        if ($howItWorksPage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $quickLinks->id,
                'label' => 'How It Works',
                'page_id' => $howItWorksPage->id,
                'url_type' => 'page',
                'order' => 2,
            ]);
        }

        MenuItem::create([
            'menu_id' => $footer->id,
            'parent_id' => $quickLinks->id,
            'label' => 'My Tickets',
            'url' => 'my.tickets',
            'url_type' => 'route',
            'order' => 3,
        ]);

        if ($aboutUsPage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $quickLinks->id,
                'label' => 'About Us',
                'page_id' => $aboutUsPage->id,
                'url_type' => 'page',
                'order' => 4,
            ]);
        }

        $support = MenuItem::create([
            'menu_id' => $footer->id,
            'label' => 'Support',
            'url_type' => 'custom',
            'order' => 2,
        ]);

        if ($helpCenterPage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $support->id,
                'label' => 'Help Center',
                'page_id' => $helpCenterPage->id,
                'url_type' => 'page',
                'order' => 1,
            ]);
        }

        if ($contactUsPage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $support->id,
                'label' => 'Contact Us',
                'page_id' => $contactUsPage->id,
                'url_type' => 'page',
                'order' => 2,
            ]);
        }

        $legal = MenuItem::create([
            'menu_id' => $footer->id,
            'label' => 'Legal',
            'url_type' => 'custom',
            'order' => 3,
        ]);

        if ($privacyPolicyPage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $legal->id,
                'label' => 'Privacy Policy',
                'page_id' => $privacyPolicyPage->id,
                'url_type' => 'page',
                'order' => 1,
            ]);
        }

        if ($termsOfServicePage) {
            MenuItem::create([
                'menu_id' => $footer->id,
                'parent_id' => $legal->id,
                'label' => 'Terms of Service',
                'page_id' => $termsOfServicePage->id,
                'url_type' => 'page',
                'order' => 2,
            ]);
        }

        $this->command->info('✓ Footer menu created with nested items');
        $this->command->info('✓ Default menus created successfully!');
    }
}
