<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Business Settings
            [
                'key' => 'business.name',
                'value' => config('app.name', 'MATIKO'),
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.email',
                'value' => 'info@matiko.com',
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.phone',
                'value' => '+254700000000',
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.address',
                'value' => 'Nairobi, Kenya',
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.description',
                'value' => 'Your premier event ticketing platform',
                'group' => 'business',
                'type' => 'text',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.logo_url',
                'value' => null,
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'business.favicon_url',
                'value' => null,
                'group' => 'business',
                'type' => 'string',
                'is_encrypted' => false,
            ],

            // SEO Settings
            [
                'key' => 'seo.title',
                'value' => 'MATIKO - Event Ticketing Platform',
                'group' => 'seo',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'seo.description',
                'value' => 'Book tickets for the best events in Kenya. Secure, fast, and reliable ticketing platform.',
                'group' => 'seo',
                'type' => 'text',
                'is_encrypted' => false,
            ],
            [
                'key' => 'seo.keywords',
                'value' => 'events, tickets, kenya, nairobi, concerts, shows, booking',
                'group' => 'seo',
                'type' => 'text',
                'is_encrypted' => false,
            ],

            // Social Media Settings
            [
                'key' => 'social.facebook',
                'value' => null,
                'group' => 'social',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'social.twitter',
                'value' => null,
                'group' => 'social',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'social.instagram',
                'value' => null,
                'group' => 'social',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'social.linkedin',
                'value' => null,
                'group' => 'social',
                'type' => 'string',
                'is_encrypted' => false,
            ],

            // Feature Flags
            [
                'key' => 'features.guest_checkout',
                'value' => 'true',
                'group' => 'features',
                'type' => 'boolean',
                'is_encrypted' => false,
            ],
            [
                'key' => 'features.mpesa_enabled',
                'value' => 'true',
                'group' => 'features',
                'type' => 'boolean',
                'is_encrypted' => false,
            ],
            [
                'key' => 'features.pesapal_enabled',
                'value' => 'true',
                'group' => 'features',
                'type' => 'boolean',
                'is_encrypted' => false,
            ],

            // PesaPal Payment Settings
            [
                'key' => 'pesapal.live',
                'value' => 'false',
                'group' => 'payment',
                'type' => 'boolean',
                'is_encrypted' => false,
            ],
            [
                'key' => 'pesapal.consumer_key',
                'value' => 'qkio1BGGYAXTu2JOfm7XSXNruoZsrqEW',
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => true,
            ],
            [
                'key' => 'pesapal.consumer_secret',
                'value' => 'osGQ364R49cXKeOYSpaOnT++rHs=',
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => true,
            ],
            [
                'key' => 'pesapal.callback_url',
                'value' => null,
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => false,
            ],
            [
                'key' => 'pesapal.ipn_url',
                'value' => null,
                'group' => 'payment',
                'type' => 'string',
                'is_encrypted' => false,
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        $this->command->info('Settings seeded successfully!');
    }
}
