#!/bin/bash
set -e

echo "==> Starting deployment process..."

# Create SQLite database file
echo "==> Creating SQLite database..."
touch /var/www/database/database.sqlite
chmod 664 /var/www/database/database.sqlite
chown www-data:www-data /var/www/database/database.sqlite

# Ensure storage permissions
echo "==> Setting permissions..."
chown -R www-data:www-data /var/www/storage /var/www/bootstrap/cache /var/www/database
chmod -R 775 /var/www/storage /var/www/bootstrap/cache /var/www/database

# Run migrations
echo "==> Running migrations..."
php artisan migrate --force --no-interaction

# Create storage link
echo "==> Creating storage link..."
php artisan storage:link --force || true

# Cache routes and views for performance
echo "==> Caching configuration..."
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Register PesaPal IPN
echo "==> Registering PesaPal..."
php artisan pesapal:auth || echo "PesaPal registration skipped"

echo "==> Deployment complete! Starting services..."

# Start supervisor
exec /usr/bin/supervisord -c /etc/supervisor/conf.d/supervisord.conf
