@props(['event'])

<div class="card-event" x-data="imageLoader()" x-intersect="$el.classList.add('animate-slide-up')">
    <a href="{{ route('events.show', $event->id) }}" class="block">
        {{-- Event Image --}}
        <div class="relative h-48 overflow-hidden bg-gradient-to-br from-matiko-500 to-matiko-600">
            @if($event->image_url)
                <img
                    src="{{ $event->image_url }}"
                    alt="{{ $event->name }}"
                    class="card-event-image"
                    x-show="loaded && !error"
                    x-on:load="onLoad()"
                    x-on:error="onError()"
                    loading="lazy"
                />
            @endif

            {{-- Gradient Fallback/Overlay --}}
            <div
                class="absolute inset-0 bg-gradient-to-br from-matiko-500 to-matiko-600"
                x-show="!loaded || error"
            >
                <div class="absolute inset-0 flex items-center justify-center">
                    <svg class="w-16 h-16 text-white/30" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>

            {{-- Dark Overlay for better text contrast --}}
            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>

            {{-- Date Badge --}}
            <div class="date-badge">
                <div class="date-badge-day">{{ $event->event_date->format('d') }}</div>
                <div class="date-badge-month">{{ $event->event_date->format('M') }}</div>
            </div>

            {{-- Status & Featured Badges --}}
            <div class="absolute top-4 right-4 flex flex-col gap-2 items-end">
                {{-- Status Badge --}}
                @if($event->isCompleted())
                    <span class="badge bg-gray-500/90 backdrop-blur-sm text-white flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-xs font-bold">Completed</span>
                    </span>
                @elseif($event->isOngoing())
                    <span class="badge bg-green-500/90 backdrop-blur-sm text-white flex items-center space-x-1 animate-pulse">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <circle cx="10" cy="10" r="3"></circle>
                        </svg>
                        <span class="text-xs font-bold">Happening Now</span>
                    </span>
                @endif

                {{-- Featured Badge --}}
                @if($event->featured)
                    <span class="badge badge-warning flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <span class="text-xs font-bold">Featured</span>
                    </span>
                @endif
            </div>

            {{-- Category Badge --}}
            @if($event->category)
                <div class="absolute bottom-4 left-4">
                    <span class="badge bg-white/90 backdrop-blur-sm text-charcoal-800 text-xs font-semibold">
                        {{ $event->category }}
                    </span>
                </div>
            @endif
        </div>

        {{-- Event Details --}}
        <div class="card-event-content">
            <h3 class="text-xl font-display font-bold text-charcoal-900 mb-2 truncate-2 hover:text-matiko-600 transition-colors">
                {{ $event->name }}
            </h3>

            {{-- Venue --}}
            <div class="flex items-center text-charcoal-600 mb-3">
                <svg class="w-5 h-5 mr-2 text-matiko-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                <span class="text-sm truncate">{{ $event->venue }}</span>
            </div>

            {{-- Date & Time --}}
            <div class="flex items-center text-charcoal-600 mb-3">
                <svg class="w-5 h-5 mr-2 text-matiko-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <span class="text-sm">
                    {{ $event->event_date->format('D, M j, Y') }} • {{ \Carbon\Carbon::parse($event->start_time)->format('g:i A') }}
                </span>
            </div>

            {{-- Description --}}
            <p class="text-charcoal-600 text-sm mb-4 truncate-2">
                {{ $event->description }}
            </p>

            {{-- Price & CTA --}}
            <div class="flex items-center justify-between">
                @if($event->min_price)
                    <div>
                        <span class="text-xs text-charcoal-500 block">Starting from</span>
                        <span class="price-tag">KES {{ number_format($event->min_price, 0) }}</span>
                    </div>
                @else
                    <div>
                        <span class="text-sm text-charcoal-600">Price: TBA</span>
                    </div>
                @endif

                @if($event->isCompleted())
                    <span class="px-4 py-2 bg-gray-300 text-gray-600 rounded-lg font-semibold text-sm cursor-not-allowed">
                        Event Ended
                    </span>
                @elseif($event->isAtCapacity())
                    <span class="px-4 py-2 bg-red-100 text-red-600 rounded-lg font-semibold text-sm">
                        Sold Out
                    </span>
                @else
                    <span class="btn-primary">
                        Get Tickets
                    </span>
                @endif
            </div>
        </div>
    </a>
</div>
