@extends('layout')

@section('title', 'All Events - MATIKO Ticketing')

@section('content')
<div class="container-custom">
    {{-- Hero Section --}}
    <div class="text-center mb-12">
        <h1 class="text-4xl md:text-5xl font-display font-bold text-charcoal-900 mb-4">
            All <span class="text-gradient">Events</span>
        </h1>
        <p class="text-lg md:text-xl text-charcoal-600 max-w-2xl mx-auto">
            Discover and book tickets for upcoming events, or browse past events. From concerts to sports, we've got you covered.
        </p>
    </div>

    {{-- Events Grid --}}
    @if($events->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-8">
            @foreach($events as $event)
                <x-event.event-card :event="$event" />
            @endforeach
        </div>
    @else
        {{-- Empty State --}}
        <div class="text-center py-16">
            <svg class="w-24 h-24 mx-auto text-charcoal-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
            </svg>
            <h3 class="text-2xl font-display font-bold text-charcoal-900 mb-2">No Events Yet</h3>
            <p class="text-charcoal-600 mb-6">Check back soon for exciting upcoming events!</p>
            <a href="{{ url('/') }}" class="btn-primary">Go Home</a>
        </div>
    @endif

    {{-- Load More (if paginated) --}}
    @if(method_exists($events, 'links'))
        <div class="mt-12">
            {{ $events->links() }}
        </div>
    @endif
</div>
@endsection
