@extends('layout')

@section('title', $event->name . ' - MATIKO Ticketing')

@section('content')
<div class="container-custom">
    {{-- Breadcrumbs --}}
    <nav class="flex mb-8 text-sm" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="{{ url('/') }}" class="text-charcoal-600 hover:text-matiko-600 transition-colors">Events</a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-4 h-4 text-charcoal-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                    <span class="ml-1 text-charcoal-900 font-medium">{{ $event->name }}</span>
                </div>
            </li>
        </ol>
    </nav>

    <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
        {{-- Hero Image Section --}}
        <div class="relative h-64 md:h-96 bg-gradient-to-br from-matiko-500 to-matiko-600" x-data="imageLoader()">
            @if($event->image_url)
                <img
                    src="{{ $event->image_url }}"
                    alt="{{ $event->name }}"
                    class="w-full h-full object-cover"
                    x-show="loaded && !error"
                    x-on:load="onLoad()"
                    x-on:error="onError()"
                />
            @endif

            {{-- Gradient Overlay --}}
            <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent"></div>

            {{-- Event Header Info --}}
            <div class="absolute bottom-0 left-0 right-0 p-6 md:p-12 text-white">
                <div class="container-custom">
                    {{-- Category Badge --}}
                    @if($event->category)
                        <span class="inline-block badge bg-matiko-500 text-white mb-4">{{ $event->category }}</span>
                    @endif

                    <h1 class="text-3xl md:text-5xl font-display font-bold mb-4">{{ $event->name }}</h1>

                    <div class="flex flex-col md:flex-row md:items-center gap-4 md:gap-6 text-base md:text-lg">
                        <div class="flex items-center">
                            <svg class="w-6 h-6 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            {{ $event->event_date->format('l, M d, Y') }}
                        </div>
                        <div class="flex items-center">
                            <svg class="w-6 h-6 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            {{ \Carbon\Carbon::parse($event->start_time)->format('g:i A') }} - {{ \Carbon\Carbon::parse($event->end_time)->format('g:i A') }}
                        </div>
                        <div class="flex items-center">
                            <svg class="w-6 h-6 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            {{ $event->venue }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Content Section --}}
        <div class="p-6 md:p-12">
            <div class="flex flex-col lg:flex-row gap-8 lg:gap-12">
                {{-- Left Column: Event Details --}}
                <div class="lg:w-2/3">
                    <h2 class="text-2xl font-display font-bold mb-6 text-charcoal-900">About This Event</h2>
                    <div class="prose prose-lg max-w-none text-charcoal-700 leading-relaxed">
                        <p>{{ $event->description }}</p>
                    </div>

                    {{-- Event Details Grid --}}
                    <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-charcoal-50 rounded-lg p-6">
                            <div class="flex items-start space-x-3">
                                <svg class="w-6 h-6 text-matiko-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                                <div>
                                    <h3 class="font-semibold text-charcoal-900 mb-1">Date</h3>
                                    <p class="text-charcoal-600">{{ $event->event_date->format('l, F j, Y') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="bg-charcoal-50 rounded-lg p-6">
                            <div class="flex items-start space-x-3">
                                <svg class="w-6 h-6 text-matiko-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <div>
                                    <h3 class="font-semibold text-charcoal-900 mb-1">Time</h3>
                                    <p class="text-charcoal-600">{{ \Carbon\Carbon::parse($event->start_time)->format('g:i A') }} - {{ \Carbon\Carbon::parse($event->end_time)->format('g:i A') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="bg-charcoal-50 rounded-lg p-6">
                            <div class="flex items-start space-x-3">
                                <svg class="w-6 h-6 text-matiko-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                <div>
                                    <h3 class="font-semibold text-charcoal-900 mb-1">Venue</h3>
                                    <p class="text-charcoal-600">{{ $event->venue }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="bg-charcoal-50 rounded-lg p-6">
                            <div class="flex items-start space-x-3">
                                <svg class="w-6 h-6 text-matiko-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                </svg>
                                <div>
                                    <h3 class="font-semibold text-charcoal-900 mb-1">Organizer</h3>
                                    <p class="text-charcoal-600">{{ $event->creator->name ?? 'MATIKO Events' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Right Column: Ticket Selection --}}
                <div class="lg:w-1/3">
                    <div class="sticky top-24">
                        <div class="bg-gradient-to-br from-matiko-50 to-white rounded-xl p-6 border-2 border-matiko-200 shadow-lg">
                            <h3 class="text-xl font-display font-bold mb-6 text-charcoal-900 flex items-center">
                                <span class="w-1 h-8 bg-matiko-600 rounded mr-3"></span>
                                Select Tickets
                            </h3>

                            @if($event->isCompleted())
                                {{-- Event has ended message --}}
                                <div class="text-center py-8">
                                    <svg class="w-16 h-16 mx-auto text-charcoal-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <p class="text-charcoal-600 font-bold text-lg">Event Has Ended</p>
                                    <p class="text-sm text-charcoal-500 mt-2">Tickets are no longer available for this event</p>
                                </div>
                            @else
                                <div class="space-y-4">
                                    @forelse($event->categories as $category)
                                    <div class="card-ticket hover:border-matiko-400 transition-all">
                                        <div class="flex justify-between items-start mb-3">
                                            <div>
                                                <h4 class="font-bold text-lg text-charcoal-900">{{ $category->name }}</h4>
                                                <p class="text-sm text-charcoal-600">{{ $category->quantity }} available</p>
                                            </div>
                                            <span class="price-tag">KES {{ number_format($category->price, 0) }}</span>
                                        </div>

                                        <form action="{{ route('checkout', $event->id) }}" method="GET">
                                            <input type="hidden" name="category" value="{{ $category->id }}">
                                            <button type="submit" class="w-full btn-primary">
                                                Select Ticket
                                            </button>
                                        </form>
                                    </div>
                                    @empty
                                        <div class="text-center py-8">
                                            <svg class="w-16 h-16 mx-auto text-charcoal-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"></path>
                                            </svg>
                                            <p class="text-charcoal-600 font-medium">No tickets available</p>
                                            <p class="text-sm text-charcoal-500 mt-1">Check back later</p>
                                        </div>
                                    @endforelse
                                </div>

                                {{-- Trust Badges --}}
                                <div class="mt-6 pt-6 border-t border-charcoal-200">
                                    <div class="flex items-center justify-center space-x-4 text-xs text-charcoal-600">
                                        <div class="flex items-center">
                                            <svg class="w-4 h-4 mr-1 text-matiko-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                            Secure Payment
                                        </div>
                                        <div class="flex items-center">
                                            <svg class="w-4 h-4 mr-1 text-matiko-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                            Instant Confirmation
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
