@extends('layout')

@section('content')
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-2xl shadow-xl overflow-hidden border border-gray-100">
        <div class="bg-gradient-to-r from-green-600 to-teal-600 p-6 text-white text-center">
            <h1 class="text-3xl font-bold">Secure Checkout</h1>
            <p class="opacity-90 mt-1">Complete your purchase securely with M-Pesa</p>
        </div>
        
        <div class="p-8">
            <!-- Order Summary -->
            <div class="bg-gray-50 rounded-xl p-6 mb-8 border border-gray-200">
                <h2 class="text-gray-800 font-bold text-lg mb-4 border-b border-gray-200 pb-2">Order Summary</h2>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-gray-600">{{ $category->event->name }}</span>
                    <span class="font-medium text-gray-800">{{ \Carbon\Carbon::parse($category->event->event_date)->format('M d, Y') }}</span>
                </div>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-gray-600">Ticket Type: {{ $category->name }}</span>
                    <span class="font-medium text-gray-800"><span id="qty-display">1</span> x Ksh {{ number_format($category->price) }}</span>
                </div>
                <div class="flex justify-between items-center mb-4">
                    <span class="text-gray-600 font-medium">Quantity</span>
                    <div class="flex items-center gap-2 bg-white border-2 border-gray-200 rounded-xl p-1">
                        <button type="button" id="qty-decrease" class="w-10 h-10 rounded-lg bg-gray-100 hover:bg-green-500 hover:text-white text-gray-700 flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md active:scale-95">
                            <svg class="w-5 h-5 font-bold" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3"><path stroke-linecap="round" stroke-linejoin="round" d="M20 12H4"></path></svg>
                        </button>
                        <input type="number" name="quantity" id="quantity" value="1" min="1" max="10" readonly class="w-14 text-center font-bold text-xl text-gray-900 bg-transparent border-0 focus:outline-none focus:ring-0">
                        <button type="button" id="qty-increase" class="w-10 h-10 rounded-lg bg-gray-100 hover:bg-green-500 hover:text-white text-gray-700 flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md active:scale-95">
                            <svg class="w-5 h-5 font-bold" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3"><path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"></path></svg>
                        </button>
                    </div>
                </div>
                <div class="flex justify-between items-center pt-4 border-t border-gray-200 text-xl font-bold text-gray-900">
                    <span>Total</span>
                    <span id="total-amount">Ksh {{ number_format($category->price) }}</span>
                </div>
            </div>

            <!-- Payment Form -->
            <form action="{{ route('orders.store') }}" method="POST" class="space-y-6">
                @csrf
                <input type="hidden" name="event_id" value="{{ $category->event->id }}">
                <input type="hidden" name="ticket_category_id" value="{{ $category->id }}">
                <input type="hidden" name="quantity" id="quantity-hidden" value="1">
                
                @guest
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                        <input type="text" name="name" id="name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition" placeholder="John Doe">
                    </div>
                     <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address (Optional)</label>
                        <input type="email" name="email" id="email" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition" placeholder="john@example.com">
                    </div>
                </div>
                @endguest

                <!-- Payment Method Selection -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-3">Select Payment Method</label>
                    <div class="grid grid-cols-1 {{ $pesapalEnabled ? 'md:grid-cols-2' : '' }} gap-4">
                        @if($mpesaEnabled)
                        <!-- M-Pesa Option -->
                        <div class="relative">
                            <input type="radio" name="payment_method" id="mpesa" value="mpesa" checked class="peer sr-only">
                            <label for="mpesa" class="flex items-center p-4 bg-white border-2 border-gray-200 rounded-lg cursor-pointer hover:border-green-500 peer-checked:border-green-600 peer-checked:bg-green-50 transition">
                                <div class="flex items-center space-x-3 flex-1">
                                    <div class="flex-shrink-0">
                                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900">M-Pesa</p>
                                        <p class="text-xs text-gray-500">Pay via STK Push</p>
                                    </div>
                                </div>
                                <div class="flex-shrink-0">
                                    <svg class="w-5 h-5 text-green-600 hidden peer-checked:block" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                                </div>
                            </label>
                        </div>
                        @endif

                        @if($pesapalEnabled)
                        <!-- PesaPal Option -->
                        <div class="relative">
                            <input type="radio" name="payment_method" id="pesapal" value="pesapal" {{ !$mpesaEnabled ? 'checked' : '' }} class="peer sr-only">
                            <label for="pesapal" class="flex items-center p-4 bg-white border-2 border-gray-200 rounded-lg cursor-pointer hover:border-blue-500 peer-checked:border-blue-600 peer-checked:bg-blue-50 transition">
                                <div class="flex items-center space-x-3 flex-1">
                                    <div class="flex-shrink-0">
                                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900">PesaPal</p>
                                        <p class="text-xs text-gray-500">Card & Mobile Money</p>
                                    </div>
                                </div>
                                <div class="flex-shrink-0">
                                    <svg class="w-5 h-5 text-blue-600 hidden peer-checked:block" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                                </div>
                            </label>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- M-Pesa Phone Number (shown only when M-Pesa is selected) -->
                <div id="mpesa-phone-section">
                    <label for="phone_number" class="block text-sm font-medium text-gray-700 mb-1">M-Pesa Phone Number</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <span class="text-gray-500 font-medium">🇰🇪 +254</span>
                        </div>
                        <input type="tel" name="phone_number" id="phone_number" class="w-full pl-20 px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition" placeholder="700 000 000">
                    </div>
                    <p class="text-xs text-gray-500 mt-1">We will send an M-Pesa prompt to this number.</p>
                </div>

                <div class="pt-4">
                    <button type="submit" id="payment-btn" class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-4 px-6 rounded-lg shadow-lg hover:shadow-xl transition duration-300 flex justify-center items-center">
                        <svg id="btn-icon" class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                        <span id="btn-text">Pay <span id="btn-amount">Ksh {{ number_format($category->price) }}</span> with M-Pesa</span>
                    </button>
                    <p id="security-text" class="text-center text-gray-500 text-sm mt-4 flex items-center justify-center">
                        <svg class="w-4 h-4 mr-1 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                        Secure Payment via Daraja API
                    </p>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const qtyInput = document.getElementById('quantity');
    const qtyDisplay = document.getElementById('qty-display');
    const totalAmount = document.getElementById('total-amount');
    const btnText = document.getElementById('btn-text');
    const btnIcon = document.getElementById('btn-icon');
    const paymentBtn = document.getElementById('payment-btn');
    const securityText = document.getElementById('security-text');
    const decreaseBtn = document.getElementById('qty-decrease');
    const increaseBtn = document.getElementById('qty-increase');
    const pricePerTicket = {{ $category->price }};

    // Payment method elements
    const mpesaRadio = document.getElementById('mpesa');
    const pesapalRadio = document.getElementById('pesapal');
    const mpesaPhoneSection = document.getElementById('mpesa-phone-section');
    const phoneInput = document.getElementById('phone_number');

    // Check if payment methods exist
    const hasMpesa = mpesaRadio !== null;
    const hasPesapal = pesapalRadio !== null;

    function updateDisplay() {
        const qty = parseInt(qtyInput.value);
        const total = qty * pricePerTicket;
        qtyDisplay.textContent = qty;
        totalAmount.textContent = 'Ksh ' + total.toLocaleString();

        // Update button text with payment method (fixed spacing)
        let paymentMethod = 'M-Pesa';
        if (hasMpesa && mpesaRadio.checked) {
            paymentMethod = 'M-Pesa';
        } else if (hasPesapal && pesapalRadio && pesapalRadio.checked) {
            paymentMethod = 'PesaPal';
        }
        btnText.innerHTML = 'Pay <span id="btn-amount">Ksh ' + total.toLocaleString() + '</span> with ' + paymentMethod;

        // Update hidden field for form submission
        document.getElementById('quantity-hidden').value = qty;

        // Disable buttons at limits with improved styling
        if (qty <= 1) {
            decreaseBtn.disabled = true;
            decreaseBtn.classList.add('opacity-40', 'cursor-not-allowed', '!hover:bg-gray-100', '!hover:text-gray-700');
            decreaseBtn.classList.remove('hover:bg-green-500', 'hover:text-white');
        } else {
            decreaseBtn.disabled = false;
            decreaseBtn.classList.remove('opacity-40', 'cursor-not-allowed', '!hover:bg-gray-100', '!hover:text-gray-700');
            decreaseBtn.classList.add('hover:bg-green-500', 'hover:text-white');
        }

        if (qty >= 10) {
            increaseBtn.disabled = true;
            increaseBtn.classList.add('opacity-40', 'cursor-not-allowed', '!hover:bg-gray-100', '!hover:text-gray-700');
            increaseBtn.classList.remove('hover:bg-green-500', 'hover:text-white');
        } else {
            increaseBtn.disabled = false;
            increaseBtn.classList.remove('opacity-40', 'cursor-not-allowed', '!hover:bg-gray-100', '!hover:text-gray-700');
            increaseBtn.classList.add('hover:bg-green-500', 'hover:text-white');
        }
    }

    function updatePaymentMethod() {
        if (hasMpesa && mpesaRadio && mpesaRadio.checked) {
            // M-Pesa styling
            mpesaPhoneSection.style.display = 'block';
            phoneInput.required = true;
            paymentBtn.classList.remove('bg-blue-600', 'hover:bg-blue-700');
            paymentBtn.classList.add('bg-green-600', 'hover:bg-green-700');

            // Update icon to mobile
            btnIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>';

            securityText.innerHTML = '<svg class="w-4 h-4 mr-1 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>Secure Payment via Daraja API';
        } else {
            // PesaPal styling
            mpesaPhoneSection.style.display = 'none';
            phoneInput.required = false;
            paymentBtn.classList.remove('bg-green-600', 'hover:bg-green-700');
            paymentBtn.classList.add('bg-blue-600', 'hover:bg-blue-700');

            // Update icon to card
            btnIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>';

            securityText.innerHTML = '<svg class="w-4 h-4 mr-1 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>Secure Payment via PesaPal';
        }
        updateDisplay();
    }

    // Event listeners for quantity controls
    decreaseBtn.addEventListener('click', function() {
        if (qtyInput.value > 1) {
            qtyInput.value = parseInt(qtyInput.value) - 1;
            updateDisplay();
        }
    });

    increaseBtn.addEventListener('click', function() {
        if (qtyInput.value < 10) {
            qtyInput.value = parseInt(qtyInput.value) + 1;
            updateDisplay();
        }
    });

    // Event listeners for payment method selection
    if (hasMpesa && mpesaRadio) {
        mpesaRadio.addEventListener('change', updatePaymentMethod);
    }
    if (hasPesapal && pesapalRadio) {
        pesapalRadio.addEventListener('change', updatePaymentMethod);
    }

    // Initialize
    updateDisplay();
    updatePaymentMethod();
});
</script>
@endsection
