<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Event Tickets</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            color: #1E293B;
            margin: 0;
            padding: 0;
        }

        .page-break {
            page-break-after: always;
            page-break-inside: avoid;
        }

        .ticket-page {
            width: 100%;
            padding: 30px;
            position: relative;
        }

        /* Header with Logo and Branding */
        .header {
            text-align: center;
            border-bottom: 3px solid #1DB954;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .logo-container {
            margin-bottom: 15px;
        }

        .logo {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #1DB954, #16A34A);
            border-radius: 12px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
        }

        .logo-text {
            color: white;
            font-size: 32px;
            font-weight: bold;
            font-family: 'Montserrat', 'Helvetica', sans-serif;
        }

        .brand-name {
            font-size: 28px;
            font-weight: bold;
            color: #1DB954;
            letter-spacing: 2px;
            margin-bottom: 5px;
        }

        .tagline {
            font-size: 12px;
            color: #64748B;
            font-style: italic;
        }

        /* Event Details Section */
        .event-section {
            background: linear-gradient(135deg, #ECFDF5, #D1FAE5);
            border-left: 5px solid #1DB954;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
        }

        .event-name {
            font-size: 26px;
            font-weight: bold;
            color: #0F172A;
            margin-bottom: 15px;
        }

        .event-details {
            font-size: 14px;
            line-height: 1.8;
        }

        .event-details .label {
            font-weight: bold;
            color: #1DB954;
            display: inline-block;
            width: 80px;
        }

        /* Ticket Info Section */
        .ticket-info {
            background: #F8FAFC;
            border: 2px dashed #CBD5E1;
            padding: 15px;
            margin-bottom: 20px;
            text-align: center;
            border-radius: 8px;
        }

        .ticket-type {
            font-size: 20px;
            font-weight: bold;
            color: #0F172A;
            margin-bottom: 10px;
        }

        .ticket-number {
            font-size: 14px;
            color: #64748B;
            font-family: 'Courier New', monospace;
            letter-spacing: 1px;
        }

        .ticket-count {
            display: inline-block;
            background: #1DB954;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-top: 10px;
        }

        /* QR Code Section */
        .qr-section {
            text-align: center;
            margin: 20px 0;
            padding: 15px;
            background: white;
            border: 2px solid #E2E8F0;
            border-radius: 8px;
        }

        .qr-title {
            font-size: 16px;
            font-weight: bold;
            color: #0F172A;
            margin-bottom: 15px;
        }

        .qr-code img {
            width: 200px;
            height: 200px;
            display: block;
            margin: 0 auto 15px;
            border: 3px solid #1DB954;
            border-radius: 8px;
            padding: 10px;
            background: white;
        }

        .qr-instruction {
            font-size: 12px;
            color: #64748B;
            font-style: italic;
        }

        /* Footer */
        .footer {
            margin-top: 20px;
            border-top: 2px solid #E2E8F0;
            padding-top: 10px;
            font-size: 11px;
            color: #64748B;
            text-align: center;
        }

        .footer-brand {
            font-weight: bold;
            color: #1DB954;
        }

        /* Security Watermark */
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 80px;
            color: rgba(29, 185, 84, 0.05);
            font-weight: bold;
            pointer-events: none;
            z-index: -1;
        }
    </style>
</head>
<body>
    @foreach($tickets as $index => $ticketData)
    <div class="ticket-page {{ $loop->last ? '' : 'page-break' }}">
        <!-- Watermark -->
        <div class="watermark">MATIKO</div>

        <!-- Header -->
        <div class="header">
            <div class="logo-container">
                <div class="logo">
                    <span class="logo-text">M</span>
                </div>
            </div>
            <div class="brand-name">MATIKO</div>
            <div class="tagline">Premium Event Ticketing Platform</div>
        </div>

        <!-- Event Details -->
        <div class="event-section">
            <div class="event-name">{{ $event->name }}</div>
            <div class="event-details">
                <div><span class="label">Date:</span> {{ \Carbon\Carbon::parse($event->event_date)->format('l, F j, Y') }}</div>
                <div><span class="label">Time:</span> {{ $event->start_time }} - {{ $event->end_time }}</div>
                <div><span class="label">Venue:</span> {{ $event->venue }}</div>
                <div><span class="label">Location:</span> {{ $event->location }}</div>
            </div>
        </div>

        <!-- Ticket Info -->
        <div class="ticket-info">
            <div class="ticket-type">{{ $ticketData['ticket']->category->name ?? 'General Admission' }}</div>
            <div class="ticket-number">{{ $ticketData['ticket']->qr_code }}</div>
            @if($tickets->count() > 1)
            <div class="ticket-count">Ticket {{ $index + 1 }} of {{ $tickets->count() }}</div>
            @endif
        </div>

        <!-- QR Code -->
        <div class="qr-section">
            <div class="qr-title">Entry QR Code</div>
            <div class="qr-code">
                {!! $ticketData['qrcode'] !!}
            </div>
            <div class="qr-instruction">Present this QR code at the entrance for scanning</div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-brand">Powered by MATIKO Ticketing • www.matiko.co.ke</div>
        </div>
    </div>
    @endforeach
</body>
</html>
