<?php

use App\Http\Controllers\Web\EventController;
use App\Http\Controllers\Web\OrderController;
use App\Http\Controllers\Web\PageController;
use Illuminate\Support\Facades\Route;

Route::get('/', [EventController::class, 'index'])->name('home');
Route::get('/events/{id}', [EventController::class, 'show'])->name('events.show');

Route::middleware(['web'])->group(function () {
    Route::get('/checkout/{event}', [OrderController::class, 'checkout'])->name('checkout');
    Route::post('/orders', [OrderController::class, 'store'])->name('orders.store');
    Route::get('/orders/{id}/success', [OrderController::class, 'success'])->name('orders.success');
    Route::get('/tickets/download/{filename}', [OrderController::class, 'downloadTicket'])->name('tickets.download');
    Route::get('/my-tickets', [OrderController::class, 'myTickets'])->middleware('auth')->name('my.tickets');
});

// CMS Pages - Must be last (catch-all)
Route::get('/page/{slug}', [PageController::class, 'show'])->name('pages.show');

require __DIR__.'/auth.php';
