<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="<?php echo e($appSettings['seo']['description'] ?? $appSettings['description'] ?? 'Premium ticketing platform for events in Kenya'); ?>">
    <meta name="theme-color" content="#1DB954">
    <title><?php echo $__env->yieldContent('title', $appSettings['seo']['title'] ?? ($appSettings['name'] . ' - Event Ticketing Platform')); ?></title>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($appSettings['favicon_url'])): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e($appSettings['favicon_url']); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-charcoal-50 antialiased">
    
    <nav class="bg-white shadow-sm sticky top-0 z-50">
        <div class="container-custom">
            <div class="flex justify-between items-center h-16 md:h-20">
                
                <div class="flex items-center">
                    <a href="<?php echo e(url('/')); ?>" class="flex items-center space-x-2">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($appSettings['logo_url'])): ?>
                            <img src="<?php echo e($appSettings['logo_url']); ?>" alt="<?php echo e($appSettings['name']); ?>" class="h-10 w-auto">
                        <?php else: ?>
                            <div class="w-10 h-10 bg-gradient-to-br from-matiko-500 to-matiko-600 rounded-lg flex items-center justify-center shadow-md">
                                <span class="text-white font-display font-bold text-xl"><?php echo e(substr($appSettings['name'] ?? 'M', 0, 1)); ?></span>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <span class="text-2xl font-display font-bold text-gradient hidden sm:block"><?php echo e($appSettings['name'] ?? 'MATIKO'); ?></span>
                    </a>
                </div>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($topbarMenu) && $topbarMenu && $topbarMenu->items->count() > 0): ?>
                    <div class="hidden md:flex items-center space-x-8">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $topbarMenu->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($item->resolved_url); ?>"
                               target="<?php echo e($item->target); ?>"
                               class="text-charcoal-700 hover:text-matiko-600 transition-colors font-medium">
                                <?php echo e($item->label); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>

    </nav>

    
    <div class="container-custom mt-6">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
            <div x-data="flashMessage()" x-show="show" x-transition class="alert alert-success flex items-start justify-between">
                <div class="flex items-start space-x-3">
                    <svg class="w-5 h-5 text-matiko-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <strong class="font-bold">Success!</strong>
                        <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
                <button @click="close()" class="text-matiko-600 hover:text-matiko-700">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
            <div x-data="flashMessage()" x-show="show" x-transition class="alert alert-error flex items-start justify-between">
                <div class="flex items-start space-x-3">
                    <svg class="w-5 h-5 text-red-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <strong class="font-bold">Error!</strong>
                        <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                    </div>
                </div>
                <button @click="close()" class="text-red-600 hover:text-red-700">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    
    <main class="min-h-screen">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    
    <footer class="bg-charcoal-900 text-charcoal-100 mt-20">
        <div class="container-custom py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
                
                <div class="col-span-1">
                    <div class="flex items-center space-x-2 mb-4">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($appSettings['logo_url'])): ?>
                            <img src="<?php echo e($appSettings['logo_url']); ?>" alt="<?php echo e($appSettings['name']); ?>" class="h-10 w-auto">
                        <?php else: ?>
                            <div class="w-10 h-10 bg-gradient-to-br from-matiko-500 to-matiko-600 rounded-lg flex items-center justify-center shadow-md">
                                <span class="text-white font-display font-bold text-xl"><?php echo e(substr($appSettings['name'] ?? 'M', 0, 1)); ?></span>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <span class="text-2xl font-display font-bold text-white"><?php echo e($appSettings['name'] ?? 'MATIKO'); ?></span>
                    </div>
                    <p class="text-charcoal-300 text-sm"><?php echo e($appSettings['description'] ?? 'Premium ticketing platform for events in Kenya. Simple, fast, and secure.'); ?></p>
                </div>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($footerMenu) && $footerMenu && $footerMenu->items->count() > 0): ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $footerMenu->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <h3 class="font-display font-bold text-white mb-4"><?php echo e($parentItem->label); ?></h3>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($parentItem->children->count() > 0): ?>
                                <ul class="space-y-2 text-sm">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $parentItem->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e($child->resolved_url); ?>"
                                               target="<?php echo e($child->target); ?>"
                                               class="text-charcoal-300 hover:text-matiko-400 transition-colors">
                                                <?php echo e($child->label); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </ul>
                            <?php else: ?>
                                <ul class="space-y-2 text-sm">
                                    <li>
                                        <a href="<?php echo e($parentItem->resolved_url); ?>"
                                           target="<?php echo e($parentItem->target); ?>"
                                           class="text-charcoal-300 hover:text-matiko-400 transition-colors">
                                            <?php echo e($parentItem->label); ?>

                                        </a>
                                    </li>
                                </ul>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <div class="border-t border-charcoal-800 pt-8">
                <p class="text-center text-charcoal-400 text-sm">&copy; <?php echo e(date('Y')); ?> <?php echo e($appSettings['name'] ?? 'MATIKO'); ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
<?php /**PATH C:\Users\Anna\Downloads\MATIKO-main (3)\MATIKO-main\resources\views/layout.blade.php ENDPATH**/ ?>