<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['event']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['event']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="card-event" x-data="imageLoader()" x-intersect="$el.classList.add('animate-slide-up')">
    <a href="<?php echo e(route('events.show', $event->id)); ?>" class="block">
        
        <div class="relative h-48 overflow-hidden bg-gradient-to-br from-matiko-500 to-matiko-600">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->image_url): ?>
                <img
                    src="<?php echo e($event->image_url); ?>"
                    alt="<?php echo e($event->name); ?>"
                    class="card-event-image"
                    x-show="loaded && !error"
                    x-on:load="onLoad()"
                    x-on:error="onError()"
                    loading="lazy"
                />
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <div
                class="absolute inset-0 bg-gradient-to-br from-matiko-500 to-matiko-600"
                x-show="!loaded || error"
            >
                <div class="absolute inset-0 flex items-center justify-center">
                    <svg class="w-16 h-16 text-white/30" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>

            
            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>

            
            <div class="date-badge">
                <div class="date-badge-day"><?php echo e($event->event_date->format('d')); ?></div>
                <div class="date-badge-month"><?php echo e($event->event_date->format('M')); ?></div>
            </div>

            
            <div class="absolute top-4 right-4 flex flex-col gap-2 items-end">
                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->isCompleted()): ?>
                    <span class="badge bg-gray-500/90 backdrop-blur-sm text-white flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span class="text-xs font-bold">Completed</span>
                    </span>
                <?php elseif($event->isOngoing()): ?>
                    <span class="badge bg-green-500/90 backdrop-blur-sm text-white flex items-center space-x-1 animate-pulse">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <circle cx="10" cy="10" r="3"></circle>
                        </svg>
                        <span class="text-xs font-bold">Happening Now</span>
                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->featured): ?>
                    <span class="badge badge-warning flex items-center space-x-1">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <span class="text-xs font-bold">Featured</span>
                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->category): ?>
                <div class="absolute bottom-4 left-4">
                    <span class="badge bg-white/90 backdrop-blur-sm text-charcoal-800 text-xs font-semibold">
                        <?php echo e($event->category); ?>

                    </span>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        
        <div class="card-event-content">
            <h3 class="text-xl font-display font-bold text-charcoal-900 mb-2 truncate-2 hover:text-matiko-600 transition-colors">
                <?php echo e($event->name); ?>

            </h3>

            
            <div class="flex items-center text-charcoal-600 mb-3">
                <svg class="w-5 h-5 mr-2 text-matiko-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                <span class="text-sm truncate"><?php echo e($event->venue); ?></span>
            </div>

            
            <div class="flex items-center text-charcoal-600 mb-3">
                <svg class="w-5 h-5 mr-2 text-matiko-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <span class="text-sm">
                    <?php echo e($event->event_date->format('D, M j, Y')); ?> • <?php echo e(\Carbon\Carbon::parse($event->start_time)->format('g:i A')); ?>

                </span>
            </div>

            
            <p class="text-charcoal-600 text-sm mb-4 truncate-2">
                <?php echo e($event->description); ?>

            </p>

            
            <div class="flex items-center justify-between">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->min_price): ?>
                    <div>
                        <span class="text-xs text-charcoal-500 block">Starting from</span>
                        <span class="price-tag">KES <?php echo e(number_format($event->min_price, 0)); ?></span>
                    </div>
                <?php else: ?>
                    <div>
                        <span class="text-sm text-charcoal-600">Price: TBA</span>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($event->isCompleted()): ?>
                    <span class="px-4 py-2 bg-gray-300 text-gray-600 rounded-lg font-semibold text-sm cursor-not-allowed">
                        Event Ended
                    </span>
                <?php elseif($event->isAtCapacity()): ?>
                    <span class="px-4 py-2 bg-red-100 text-red-600 rounded-lg font-semibold text-sm">
                        Sold Out
                    </span>
                <?php else: ?>
                    <span class="btn-primary">
                        Get Tickets
                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </a>
</div>
<?php /**PATH C:\Users\Anna\Downloads\MATIKO-main (3)\MATIKO-main\resources\views/components/event/event-card.blade.php ENDPATH**/ ?>