import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/js/app.js',
            ],
            refresh: true,
        }),
    ],
    build: {
        // Optimize for production
        rollupOptions: {
            output: {
                manualChunks: {
                    // Separate vendor chunk for better caching
                    'alpine': ['alpinejs'],
                },
            },
        },
        // Target modern browsers for smaller bundle
        target: 'es2015',
        // Minify for production
        minify: 'terser',
        terserOptions: {
            compress: {
                drop_console: true, // Remove console.log in production
            },
        },
    },
});
